﻿Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.Runtime.InteropServices
Imports Microsoft.Win32.SafeHandles


Namespace VBEloPubInterface

	<Flags> _
    Public Enum GETPOINTS_STATUS
        InitialTouch = &H1
        StreamTouch = &H2
        UnTouch = &H4
    End Enum

    <Flags()> _
    Public Enum VrtlBoundMode
        enumVrtlDeskDisabled = &H0
        ' no virtual desktop
        enumVrtlNoBounds = &H1
        ' NO virtual desktop bounds, No Clipping, Cursor visible
        enumVrtlBoundsClipped = &H2
        ' virtual desktop bounds enable, Clipping, Cursor moves at bounds
        enumVrtlBoundsFreeze = &H3
        ' virtual desktop bounds enable, Clipping, Cursor Freezes at bounds
    End Enum

    <Flags()> _
    Public Enum APR_PREFERENCES
        APR_Gaming = &H0
        APR_Signature = &H1
        APR_General = &H2
        APR_POS = &H3
        APR_Custom = &H4
        ' used by EloGetAprPreference only, indicating a customized settings in use.
    End Enum

    <Flags()> _
    Public Enum GETPOINTS_CODE
        ' the blocked call returns data depending on this flag
        NoRequest = &H0
        ReturnImmediately = &H1
        ReturnOnTouch = &H2
        ReturnOnUntouch = &H3
        ReturnOnNextValidTouch = &H4
        LVS_STREAM = &H5
        LVS_AUDIO_OVERLOAD = &H6
        LVS_AUDIO_LOWSCORE = &H7
        LVS_AUDIO_HIVARIANCE = &H8
        LVS_INIT = &H9
    End Enum

    <Flags()> _
    Public Enum CONTRL_STAT
        ' ctrl_status values
        CS_OK = &H0
        CS_ConstantTouch = &H1
        CS_CanNotFindController = &H2
        CS_NoResponse = &H3
        CS_InvalidResponse = &H4
        CS_CanNotSetBaudRate = &H5
        CS_CommandNotSent = &H6
        CS_SystemError = &H7
        CS_InvalidCommPort = &H8
        CS_CommPortFailedOpen = &H9
        CS_CommPortCommandError = &H10
        CS_CommPortNoController = &H11
        CS_UndefinedController = &H12
    End Enum

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure ClippingBounds
        ' IN Set calibrate data input buffer
        Public X_Max As Int32
        Public X_Min As Int32
        Public Y_Max As Int32
        Public Y_Min As Int32
        Public Z_Max As Int32
        Public Z_Min As Int32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure EDGE_ACCEL
        Private Const EDGE_ACCEL_SIZE As Integer = 1
        Public Enable As UInt32
        Public Scale As UInt32
        <MarshalAs(UnmanagedType.Struct, SizeConst:=EDGE_ACCEL_SIZE)> _
        Public Bounds As ClippingBounds
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure TOUCH_BOUNDARY
        Public Bounds As ClippingBounds
        Public ClippingMode As VrtlBoundMode
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure TOUCH_POINT
        Public x As Int32
        Public y As Int32
        Public z As Int32
        Public Status As GETPOINTS_STATUS
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure QUICK_TOUCH
        Public bEnable As UInt32
        Public Dx As UInt32
        Public Dy As UInt32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure BEEP
        Public BeepFlag As Int32
        Public BeepFreq As UInt32
        Public BeepTime As UInt32
        Public UseExternalSpeaker As Int32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure DRAG_DELAY
        Public MinDragDelay As UInt32
        Public MaxDragDelay As UInt32
        Public DragDelay As UInt32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure RIGHT_BUTTON
        Public RightClickHW As UInt32
        Public InitialTimeout As UInt32
        Public DefaultRightClickDelay As UInt32
        Public MaxRightClickDelay As UInt32
        Public MinRightClickDelay As UInt32
        Public ClickCount As UInt32
        Public Active As UInt32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure UNTOUCH_TIMEOUT
        Public TimeOut As UInt32
        Public Width As UInt32
        Public Height As UInt32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure POINT
        Public x As Int32
        Public y As Int32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure CALIBRATION
        Public EloDx As Int32
        Public ScrDx As Int32
        Public X_Offset As Int32
        Public EloDy As Int32
        Public ScrDy As Int32
        Public Y_Offset As Int32
        Public EloDz As Int32
        Public ScrDz As Int32
        Public Z_Offset As Int32
        Public WindowsMonitorNumber As UInt32
        Public xyswap As UInt32
        Public xRes As Int32
        ' x, y monitor resolution at which these calculations were made
        Public yRes As Int32
        Public xVirtScrSize As Int32
        ' Width and height, in pixels, of the virtual screen. 
        Public yVirtScrSize As Int32
        ' The virtual screen is the bounding rectangle of all display monitors.
        Public xVirtScrCoord As Int32
        ' Coordinates for the left side and the top of the virtual screen. 
        Public yVirtScrCoord As Int32
        Public xMonLocn As Int32
        ' monitor location
        Public yMonLocn As Int32

        Public VDeskMode As Int32
        Public nScreenIndex As Int32

        Private Const CALIB_TOUCH_SIZE As Integer = 3
        <MarshalAs(UnmanagedType.Struct, SizeConst:=CALIB_TOUCH_SIZE)> _
        Public xyTouch As POINT
        <MarshalAs(UnmanagedType.Struct, SizeConst:=CALIB_TOUCH_SIZE)> _
        Public xyTarget As POINT
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure SCREEN_PROPERTIES
        Private Const COMPORT_NAME_LENGTH As Integer = 256
        Public iWindowsMonNo As Int32
        Public Type As UInt32
        ' unicode
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=COMPORT_NAME_LENGTH)> _
        Public Port As [String]

        Private Const SERIALNUMBER_NAME_LENGTH As Integer = 18
        ' the rest is ansi
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=SERIALNUMBER_NAME_LENGTH)> _
        Public SerialNumber As [String]
        Public HardwareHandshaking As UInt32
        Public ctrl_status As CONTRL_STAT
        Public BaudRate As Int32
        Public crevminor As [SByte]
        Public crevmajor As [SByte]
        Public trevminor As [SByte]
        Public trevmajor As [SByte]
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> _
        Public diagcodes As [String]
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> _
        Public id As [String]
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> _
        Public cnt_id As [String]
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> _
        Public driver_id As [String]
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure NVRAM_CAL_DATA
        Public dwEDID As UInt32
        ' 4-byte serial number in monitor's EDID (Extended Display Identification Data)
        Public nEloDx As Int32
        Public nEloDy As Int32
        Public nScreenDx As Int32
        Public nScreenDy As Int32
        Public nOffsetX As Int32
        Public nOffsetY As Int32
        Public bSwapXY As Int32
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure CLIP_RECT
        Public MonitorNumber As Int32
        Public NumBounds As UInt32

        <MarshalAs(UnmanagedType.Struct, SizeConst:=64)> _
        Public Bounds As ClippingBounds
        Public ExclusionFlag As UInt32
        Public ClippingMode As VrtlBoundMode
    End Structure

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure SMARTSET_DATA
        Public ScreenNumber As Int32

        <StructLayout(LayoutKind.Explicit, CharSet:=CharSet.Ansi)> _
        Public Structure UNION
            <FieldOffset(0)> _
            <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> _
            Public Command As [String]
            <FieldOffset(0)> _
            Public Response As UInt16
        End Structure
    End Structure

    Public Class EloPubIf
        Private Const MAX_SUPPORTED_SCR As Integer = 256

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetScreenInfo(<MarshalAs(UnmanagedType.LPArray, ArraySubType:=UnmanagedType.I4, SizeConst:=MAX_SUPPORTED_SCR)> <Out()> dwMonNo As UInt32(), ByRef iScrCnt As Int32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetTouch(ByRef tpxy As TOUCH_POINT, xlated As Int32, getCode As GETPOINTS_CODE, ByRef nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloCancel() As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetMouseMode(ByRef pwMode As Int16, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetMouseMode(wMode As Int16, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetTouchReportingState(ByRef pbFlag As Int32, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetTouchReportingState(bFlag As Int32, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetDragDelay(ByRef pDragDelay As DRAG_DELAY, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetDragDelay(ByRef pDragDelay As DRAG_DELAY, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetBeep(ByRef psndVal As BEEP, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetBeep(ByRef psndVal As BEEP, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetTouchBoundary(ByRef ptBndry As TOUCH_BOUNDARY, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetTouchBoundary(ByRef ptBndry As TOUCH_BOUNDARY, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetCalibrationData(ByRef pCalData As CALIBRATION, nScrNum As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetCalibrationData(ByRef pCalData As CALIBRATION, nScrNum As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSwapButton(hWnd As IntPtr, dwCnt As UInt32, nScrNum As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetLeftHandedMouse(bFlag As Int32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetDiagnosticsData(ByRef pData As SCREEN_PROPERTIES, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetQuickTouch(ByRef pQTouch As QUICK_TOUCH, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetQuickTouch(ByRef pQTouch As QUICK_TOUCH, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetEdgeAccel(ByRef pAccel As EDGE_ACCEL, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetEdgeAccel(ByRef pAccel As EDGE_ACCEL, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetUntouchTimeout(ByRef pUTimeout As UNTOUCH_TIMEOUT, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetUntouchTimeout(ByRef pUTimeout As UNTOUCH_TIMEOUT, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetRightClickOnHold(ByRef pRBHold As RIGHT_BUTTON, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetRightClickOnHold(ByRef pRBHold As RIGHT_BUTTON, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetNVRamCalData(ByRef pNVRamCalData As NVRAM_CAL_DATA, nScrNo As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSendSmartsetCommand(ByRef pSmartsetData As SMARTSET_DATA) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetSmartsetResponseStatus(ByRef pSmartsetData As SMARTSET_DATA) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetSmartsetResponse(ByRef pSmartsetData As SMARTSET_DATA) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetAprPreference(nScreenIndex As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetAprPreference(nScreenIndex As UInt32, apr_pref As APR_PREFERENCES) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetAprParameters(nScreenIndex As UInt32, ByRef pnParameters As UInt32, ByRef pnParameterCount As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetAprParameters(nScreenIndex As UInt32, ByRef pnParameters As UInt32, nParameterCount As UInt32) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetClipRectangles(ByRef pClipRect As CLIP_RECT) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloSetClipRectangles(ByRef pClipRect As CLIP_RECT) As Integer
        End Function

        <DllImport("EloPubIf.dll")> _
        Public Shared Function EloGetSerialNumbers(nScreenIndex As UInt32, <[In](), Out()> pszUsbControllerSN As Char(), nUsbControllerSNBufLen As UInt32, <[In](), Out()> pszSensorSN As Char(), nSensorSNBufLen As UInt32) As Integer
        End Function

    End Class

    Public Class Win32
        <DllImport("kernel32.dll")> _
        Public Shared Function GetPrivateProfileString(lpAppName As String, lpKeyName As String, lpDefault As String, <[In](), Out()> lpReturnedString As Char(), nSize As UInteger, lpFileName As String) As UInteger
        End Function

        <DllImport("kernel32.dll")> _
        Public Shared Function WritePrivateProfileString(lpAppName As String, lpKeyName As String, lpString As String, lpFileName As String) As Boolean
        End Function

        <DllImport("user32.dll")> _
        Public Shared Function ShowCursor(bShow As Boolean) As Integer
        End Function

        <DllImport("USER32.DLL")> _
        Public Shared Function FindWindow(lpClassName As String, lpWindowName As String) As Integer
        End Function

        <DllImport("shlwapi.dll")> _
        Public Shared Function PathFileExists(fname As String) As Boolean
        End Function
    End Class
End Namespace
